<?php
require_once '../includes/middleware.php';

$pageTitle = 'Upload Produk';
$activePage = 'upload-produk';

// Get kategori dan lokasi
$kategoriBukaOlshop = [];
$lokasiBukaOlshop = [];

$result = $api->getKategoriDanLokasi();
if (isset($result['success']) && $result['success']) {
    $kategoriBukaOlshop = $result['data']['kategori'] ?? [];
    $lokasiBukaOlshop = $result['data']['lokasi'] ?? [];
}

ob_start();
?>

<!-- Nav Tabs -->
<ul class="nav nav-tabs mb-4" role="tablist">
    <li class="nav-item">
        <button class="nav-link active" id="manual-tab" data-bs-toggle="tab" data-bs-target="#manual-form" type="button">
            <i class="fas fa-keyboard"></i> Upload Manual
        </button>
    </li>
    <li class="nav-item">
        <button class="nav-link" id="csv-tab" data-bs-toggle="tab" data-bs-target="#csv-form" type="button">
            <i class="fas fa-file-csv"></i> Upload CSV
        </button>
    </li>
</ul>

<!-- Tab Content -->
<div class="tab-content">
    <!-- Manual Upload -->
    <div class="tab-pane fade show active" id="manual-form" role="tabpanel">
        <div class="row">
            <div class="col-lg-8">
                <form id="manualForm" class="needs-validation" novalidate>
                    <div id="productsContainer">
                        <!-- Product Form 1 -->
                        <div class="product-form card mb-3 border-primary" data-product-id="1">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h6 class="mb-0"><i class="fas fa-box"></i> Produk #1</h6>
                                <button type="button" class="btn btn-sm btn-outline-danger remove-product" style="display: none;">
                                    <i class="fas fa-trash"></i> Hapus
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">ID Kategori *</label>
                                        <input type="hidden" class="id-kategori-value" value="">
                                        <div class="d-flex gap-2">
                                            <input type="text" class="form-control form-control-sm kategori-search" 
                                                   placeholder="Cari kategori..." autocomplete="off">
                                            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" 
                                                    data-bs-target="#kategoriModal">
                                                <i class="fas fa-list"></i>
                                            </button>
                                        </div>
                                        <div class="kategori-suggestions mt-2" style="max-height: 150px; overflow-y: auto; display: none;"></div>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">ID Lokasi *</label>
                                        <input type="hidden" class="id-lokasi-value" value="">
                                        <div class="d-flex gap-2">
                                            <input type="text" class="form-control form-control-sm lokasi-search" 
                                                   placeholder="Cari lokasi..." autocomplete="off">
                                            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" 
                                                    data-bs-target="#lokasiModal">
                                                <i class="fas fa-list"></i>
                                            </button>
                                        </div>
                                        <div class="lokasi-suggestions mt-2" style="max-height: 150px; overflow-y: auto; display: none;"></div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Jenis Barang *</label>
                                        <select class="form-select jenis-barang" required>
                                            <option value="">-- Pilih --</option>
                                            <option value="fisik">Fisik</option>
                                            <option value="digital">Digital</option>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Nama Barang *</label>
                                        <input type="text" class="form-control nama-barang" placeholder="Judul produk" required>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Deskripsi Singkat *</label>
                                    <textarea class="form-control deskripsi-singkat" rows="2" placeholder="Deskripsi singkat produk" required></textarea>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Deskripsi Panjang *</label>
                                    <textarea class="form-control deskripsi-panjang" rows="3" placeholder="Deskripsi lengkap produk" required></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Harga Barang *</label>
                                        <input type="number" class="form-control harga-barang" placeholder="0" min="1" required>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Stok Barang *</label>
                                        <input type="number" class="form-control stok-barang" placeholder="0" min="0" required>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Harga Modal</label>
                                        <input type="number" class="form-control harga-modal" placeholder="0" min="0">
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Harga Asli (Sebelum Diskon)</label>
                                        <input type="number" class="form-control harga-barang-asli" placeholder="0" min="0">
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">URL Gambar Utama *</label>
                                    <input type="url" class="form-control url-gambar-1" placeholder="https://..." required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">URL Gambar Tambahan</label>
                                    <input type="url" class="form-control url-gambar-2" placeholder="https://...">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex gap-2 mb-3">
                        <button type="button" class="btn btn-outline-primary" id="addProductBtn">
                            <i class="fas fa-plus"></i> Tambah Produk
                        </button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-upload"></i> Upload
                        </button>
                    </div>
                </form>
            </div>

            <div class="col-lg-4">
                <div class="card bg-light">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-info-circle"></i> Informasi</h6>
                    </div>
                    <div class="card-body">
                        <p class="small mb-2"><strong>Tips:</strong></p>
                        <ul class="small ps-3 mb-0">
                            <li>Isi semua field yang berlabel *</li>
                            <li>URL gambar harus valid dan dapat diakses</li>
                            <li>Gunakan Rp tanpa pemisah untuk harga</li>
                            <li>Anda bisa menambah multiple produk sekaligus</li>
                            <li>Produk akan tersimpan dalam antrian upload</li>
                        </ul>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-history"></i> Status Upload</h6>
                    </div>
                    <div class="card-body" id="uploadStatus" style="min-height: 100px;">
                        <p class="text-muted text-center mb-0">Belum ada upload</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CSV Upload -->
    <div class="tab-pane fade" id="csv-form" role="tabpanel">
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-file-csv"></i> Upload File CSV</h5>
                    </div>
                    <div class="card-body">
                        <form id="csvForm" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label class="form-label">File CSV *</label>
                                <input type="file" class="form-control" id="csvFile" name="csv_file" accept=".csv" required>
                                <small class="text-muted">Format: CSV, Maksimal 10MB</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="validateFirst" checked>
                                    <span>Validasi file sebelum upload</span>
                                </label>
                            </div>

                            <div class="alert alert-info alert-sm">
                                <i class="fas fa-lightbulb"></i> 
                                <a href="/api/download-template" class="alert-link">Download Template CSV</a> untuk melihat format yang benar
                            </div>

                            <div id="csvPreview" style="display: none;" class="mb-3">
                                <h6>Preview Data:</h6>
                                <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                                    <table class="table table-sm table-hover" id="csvPreviewTable">
                                        <thead></thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('csvFile').value=''; document.getElementById('csvPreview').style.display='none';">
                                    <i class="fas fa-times"></i> Batal
                                </button>
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-upload"></i> Upload CSV
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card bg-light">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-info-circle"></i> Format CSV</h6>
                    </div>
                    <div class="card-body small">
                        <p class="mb-2"><strong>Kolom Wajib:</strong></p>
                        <ul class="ps-3 mb-3 small">
                            <li>id_kategori</li>
                            <li>id_lokasi</li>
                            <li>jenis_barang</li>
                            <li>nama_barang</li>
                            <li>deskripsi_singkat</li>
                            <li>deskripsi_panjang</li>
                            <li>harga_barang</li>
                            <li>stok_barang</li>
                            <li>url_gambar_barang_1</li>
                        </ul>

                        <p class="mb-2"><strong>Kolom Opsional:</strong></p>
                        <ul class="ps-3 small">
                            <li>url_gambar_barang_2</li>
                            <li>harga_modal</li>
                            <li>harga_barang_asli</li>
                            <li>sku</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Kategori Modal -->
<div class="modal fade" id="kategoriModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-tags"></i> Pilih Kategori</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="text" class="form-control mb-3" id="kategoriFilter" placeholder="Cari kategori...">
                <div id="kategoriList">
                    <?php foreach ($kategoriBukaOlshop as $kat): ?>
                        <div class="form-check">
                            <input class="form-check-input kategori-checkbox" type="radio" name="kategori" 
                                   id="kat_<?php echo $kat['id_kategori']; ?>" 
                                   value="<?php echo $kat['id_kategori']; ?>"
                                   data-nama="<?php echo htmlspecialchars($kat['nama_kategori']); ?>">
                            <label class="form-check-label" for="kat_<?php echo $kat['id_kategori']; ?>">
                                <?php echo htmlspecialchars($kat['nama_kategori']); ?>
                                <small class="text-muted">(<?php echo $kat['id_kategori']; ?>)</small>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-primary" id="selectKategoriBtn" data-bs-dismiss="modal">Pilih</button>
            </div>
        </div>
    </div>
</div>

<!-- Lokasi Modal -->
<div class="modal fade" id="lokasiModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-map-marker-alt"></i> Pilih Lokasi</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="text" class="form-control mb-3" id="lokasiFilter" placeholder="Cari lokasi...">
                <div id="lokasiList">
                    <?php foreach ($lokasiBukaOlshop as $lok): ?>
                        <div class="form-check">
                            <input class="form-check-input lokasi-checkbox" type="radio" name="lokasi" 
                                   id="lok_<?php echo $lok['id_lokasi']; ?>" 
                                   value="<?php echo $lok['id_lokasi']; ?>"
                                   data-nama="<?php echo htmlspecialchars($lok['nama_pengirim']); ?>">
                            <label class="form-check-label" for="lok_<?php echo $lok['id_lokasi']; ?>">
                                <?php echo htmlspecialchars($lok['nama_pengirim']); ?>
                                <small class="text-muted">(<?php echo $lok['tipe_lokasi']; ?>)</small>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-primary" id="selectLokasiBtn" data-bs-dismiss="modal">Pilih</button>
            </div>
        </div>
    </div>
</div>

<script>
let productCounter = 1;
let selectedKategoriProductId = null;
let selectedLokasiProductId = null;

// Initialize first product
document.addEventListener('DOMContentLoaded', function() {
    setupProductForm(1);
});

function setupProductForm(productId) {
    const form = document.querySelector(`.product-form[data-product-id="${productId}"]`);
    if (!form) return;

    // Kategori search
    const kategoriSearch = form.querySelector('.kategori-search');
    const kategoriSuggestions = form.querySelector('.kategori-suggestions');
    
    kategoriSearch?.addEventListener('input', function(e) {
        const value = e.target.value.toLowerCase();
        const suggestions = [<?php echo implode(',', array_map(function($k) {
            return 'JSON.stringify({id: "'.$k['id_kategori'].'", nama: "'.$k['nama_kategori'].'"})';
        }, $kategoriBukaOlshop)); ?>];

        if (value.length < 1) {
            kategoriSuggestions.style.display = 'none';
            return;
        }

        const filtered = suggestions
            .map(s => JSON.parse(s))
            .filter(s => s.nama.toLowerCase().includes(value));

        if (filtered.length === 0) {
            kategoriSuggestions.innerHTML = '<small class="text-muted ms-2">Tidak ditemukan</small>';
        } else {
            kategoriSuggestions.innerHTML = filtered.map(s => 
                `<div class="p-2 border-bottom kategori-item" style="cursor: pointer;" data-id="${s.id}" data-nama="${s.nama}">
                    <small>${s.nama} <strong>${s.id}</strong></small>
                </div>`
            ).join('');
        }

        kategoriSuggestions.style.display = 'block';
    });

    kategoriSuggestions?.addEventListener('click', function(e) {
        if (e.target.closest('.kategori-item')) {
            const item = e.target.closest('.kategori-item');
            form.querySelector('.id-kategori-value').value = item.dataset.id;
            kategoriSearch.value = item.dataset.nama;
            kategoriSuggestions.style.display = 'none';
        }
    });

    // Similar for lokasi...
    const lokasiSearch = form.querySelector('.lokasi-search');
    const lokasiSuggestions = form.querySelector('.lokasi-suggestions');
    
    lokasiSearch?.addEventListener('input', function(e) {
        const value = e.target.value.toLowerCase();
        const suggestions = [<?php echo implode(',', array_map(function($l) {
            return 'JSON.stringify({id: "'.$l['id_lokasi'].'", nama: "'.$l['nama_pengirim'].'"})';
        }, $lokasiBukaOlshop)); ?>];

        if (value.length < 1) {
            lokasiSuggestions.style.display = 'none';
            return;
        }

        const filtered = suggestions
            .filter(s => {
                const parsed = JSON.parse(s);
                return parsed.nama.toLowerCase().includes(value);
            });

        if (filtered.length === 0) {
            lokasiSuggestions.innerHTML = '<small class="text-muted ms-2">Tidak ditemukan</small>';
        } else {
            lokasiSuggestions.innerHTML = filtered.map(s => {
                const parsed = JSON.parse(s);
                return `<div class="p-2 border-bottom lokasi-item" style="cursor: pointer;" data-id="${parsed.id}" data-nama="${parsed.nama}">
                    <small>${parsed.nama} <strong>${parsed.id}</strong></small>
                </div>`;
            }).join('');
        }

        lokasiSuggestions.style.display = 'block';
    });

    lokasiSuggestions?.addEventListener('click', function(e) {
        if (e.target.closest('.lokasi-item')) {
            const item = e.target.closest('.lokasi-item');
            form.querySelector('.id-lokasi-value').value = item.dataset.id;
            lokasiSearch.value = item.dataset.nama;
            lokasiSuggestions.style.display = 'none';
        }
    });

    // Remove button handler
    form.querySelector('.remove-product')?.addEventListener('click', function() {
        form.remove();
        updateRemoveButtons();
    });
}

function updateRemoveButtons() {
    const forms = document.querySelectorAll('.product-form');
    forms.forEach((form, index) => {
        form.querySelector('.remove-product').style.display = forms.length > 1 ? 'block' : 'none';
    });
}

document.getElementById('addProductBtn')?.addEventListener('click', function() {
    productCounter++;
    const container = document.getElementById('productsContainer');
    const newForm = container.querySelector('.product-form').cloneNode(true);
    newForm.dataset.productId = productCounter;
    newForm.querySelector('h6').textContent = `Produk #${productCounter}`;
    
    // Clear all values
    newForm.querySelectorAll('input, textarea, select').forEach(el => {
        if (el.type !== 'hidden') el.value = '';
    });
    
    container.appendChild(newForm);
    setupProductForm(productCounter);
    updateRemoveButtons();
});

// Manual form submit
document.getElementById('manualForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const forms = document.querySelectorAll('.product-form');
    const products = [];
    
    for (const form of forms) {
        if (!form.querySelector('.id-kategori-value').value) {
            showToast('Pilih kategori untuk semua produk', 'danger');
            return;
        }
        if (!form.querySelector('.id-lokasi-value').value) {
            showToast('Pilih lokasi untuk semua produk', 'danger');
            return;
        }
        
        products.push({
            id_kategori: form.querySelector('.id-kategori-value').value,
            id_lokasi: form.querySelector('.id-lokasi-value').value,
            jenis_barang: form.querySelector('.jenis-barang').value,
            nama_barang: form.querySelector('.nama-barang').value,
            deskripsi_singkat: form.querySelector('.deskripsi-singkat').value,
            deskripsi_panjang: form.querySelector('.deskripsi-panjang').value,
            harga_barang: form.querySelector('.harga-barang').value,
            stok_barang: form.querySelector('.stok-barang').value,
            harga_modal: form.querySelector('.harga-modal').value,
            harga_barang_asli: form.querySelector('.harga-barang-asli').value,
            url_gambar_barang_1: form.querySelector('.url-gambar-1').value,
            url_gambar_barang_2: form.querySelector('.url-gambar-2').value
        });
    }

    try {
        const response = await fetch('/api/upload-produk', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({products})
        });

        const data = await response.json();
        
        if (data.success) {
            showToast(`${data.count} produk berhasil diupload`, 'success');
            document.getElementById('manualForm').reset();
            
            // Reset to single form
            document.getElementById('productsContainer').innerHTML = `
                <div class="product-form card mb-3 border-primary" data-product-id="1">
                    <!-- Form akan di-reset oleh JavaScript -->
                </div>
            `;
            productCounter = 1;
        } else {
            showToast(data.message || 'Gagal upload produk', 'danger');
        }
    } catch (error) {
        showToast('Error: ' + error.message, 'danger');
    }
});

// CSV form submit
document.getElementById('csvForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const file = document.getElementById('csvFile').files[0];
    if (!file) {
        showToast('Pilih file CSV', 'danger');
        return;
    }

    const formData = new FormData();
    formData.append('csv_file', file);

    try {
        const response = await fetch('/api/upload-csv', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();
        
        if (data.success) {
            showToast(`${data.count} produk dari CSV berhasil diupload`, 'success');
            document.getElementById('csvForm').reset();
            document.getElementById('csvPreview').style.display = 'none';
        } else {
            showToast(data.message || 'Gagal upload CSV', 'danger');
        }
    } catch (error) {
        showToast('Error: ' + error.message, 'danger');
    }
});

// Modal selection handlers
document.getElementById('selectKategoriBtn')?.addEventListener('click', function() {
    const selected = document.querySelector('input[name="kategori"]:checked');
    if (selected && selectedKategoriProductId) {
        const form = document.querySelector(`.product-form[data-product-id="${selectedKategoriProductId}"]`);
        if (form) {
            form.querySelector('.id-kategori-value').value = selected.value;
            form.querySelector('.kategori-search').value = selected.dataset.nama;
        }
    }
});

document.getElementById('selectLokasiBtn')?.addEventListener('click', function() {
    const selected = document.querySelector('input[name="lokasi"]:checked');
    if (selected && selectedLokasiProductId) {
        const form = document.querySelector(`.product-form[data-product-id="${selectedLokasiProductId}"]`);
        if (form) {
            form.querySelector('.id-lokasi-value').value = selected.value;
            form.querySelector('.lokasi-search').value = selected.dataset.nama;
        }
    }
});

// Search in modals
document.getElementById('kategoriFilter')?.addEventListener('input', function(e) {
    const value = e.target.value.toLowerCase();
    document.querySelectorAll('#kategoriList .form-check').forEach(check => {
        const label = check.querySelector('label').textContent;
        check.style.display = label.toLowerCase().includes(value) ? 'block' : 'none';
    });
});

document.getElementById('lokasiFilter')?.addEventListener('input', function(e) {
    const value = e.target.value.toLowerCase();
    document.querySelectorAll('#lokasiList .form-check').forEach(check => {
        const label = check.querySelector('label').textContent;
        check.style.display = label.toLowerCase().includes(value) ? 'block' : 'none';
    });
});

// CSV file preview
document.getElementById('csvFile')?.addEventListener('change', async function(e) {
    const file = e.target.files[0];
    if (!file) return;

    const reader = new FileReader();
    reader.onload = function(event) {
        const csv = event.target.result;
        const lines = csv.split('\n');
        const headers = lines[0].split(',').map(h => h.trim());
        
        const table = document.getElementById('csvPreviewTable');
        table.querySelector('thead').innerHTML = '<tr>' + 
            headers.map(h => `<th>${h}</th>`).join('') + 
            '</tr>';
        
        const tbody = table.querySelector('tbody');
        tbody.innerHTML = '';
        for (let i = 1; i < Math.min(lines.length, 6); i++) {
            const values = lines[i].split(',');
            tbody.innerHTML += '<tr>' + 
                values.map(v => `<td><small>${v.trim().substring(0, 30)}</small></td>`).join('') + 
                '</tr>';
        }
        
        document.getElementById('csvPreview').style.display = 'block';
    };
    reader.readAsText(file);
});
</script>

<?php
$content = ob_get_clean();
include '../includes/layout.php';
?>
