<?php
require_once '../includes/middleware.php';

$pageTitle = 'Pengaturan';
$activePage = 'setting';

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $apiKey = $_POST['api_key'] ?? '';
    
    if (empty($apiKey)) {
        $message = '<div class="alert alert-danger">API Key tidak boleh kosong</div>';
    } else {
        $db = Database::getInstance();
        $result = $db->update(
            'admin_users',
            ['api_key' => $apiKey],
            'id = ?',
            'is',
            [&$currentUser['id'], &$apiKey]
        );
        
        if ($result) {
            $_SESSION['api_key'] = $apiKey;
            $message = '<div class="alert alert-success"><i class="fas fa-check-circle"></i> API Key berhasil diupdate</div>';
        } else {
            $message = '<div class="alert alert-danger">Gagal mengupdate API Key</div>';
        }
    }
}

$db = Database::getInstance();
$user = $db->fetch("SELECT api_key FROM admin_users WHERE id = ?", "i", [&$currentUser['id']]);

ob_start();
?>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-key"></i> API Key BukaOlshop</h5>
            </div>
            <div class="card-body">
                <?php echo $message; ?>
                
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">API Key *</label>
                        <input type="text" class="form-control" name="api_key" 
                               value="<?php echo htmlspecialchars($user['api_key'] ?? ''); ?>" required>
                        <small class="text-muted">Dapatkan API Key dari aplikasi BukaOlshop</small>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Simpan API Key
                    </button>
                </form>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Informasi Sistem</h5>
            </div>
            <div class="card-body">
                <table class="table table-sm mb-0">
                    <tr>
                        <td><strong>PHP Version</strong></td>
                        <td><?php echo phpversion(); ?></td>
                    </tr>
                    <tr>
                        <td><strong>MySQL Version</strong></td>
                        <td>
                            <?php
                            try {
                                $dbc = Database::getInstance()->getConnection();
                                echo $dbc->get_server_info();
                            } catch (Exception $e) {
                                echo 'Unknown';
                            }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Upload Max Size</strong></td>
                        <td><?php echo ini_get('upload_max_filesize'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Memory Limit</strong></td>
                        <td><?php echo ini_get('memory_limit'); ?></td>
                    </tr>
                    <tr>
                        <td><strong>cURL Support</strong></td>
                        <td><?php echo extension_loaded('curl') ? '<span class="badge badge-success">Yes</span>' : '<span class="badge badge-danger">No</span>'; ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card bg-light">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-lightbulb"></i> Bantuan</h6>
            </div>
            <div class="card-body small">
                <p><strong>Cara Dapatkan API Key:</strong></p>
                <ol class="ps-3">
                    <li>Buka aplikasi BukaOlshop</li>
                    <li>Ke menu Pengaturan</li>
                    <li>Pilih "Generate API Key"</li>
                    <li>Copy API Key yang muncul</li>
                    <li>Paste di form di atas</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include '../includes/layout.php';
?>
