<?php
require_once '../includes/middleware.php';

$pageTitle = 'Riwayat Upload';
$activePage = 'riwayat';

$db = Database::getInstance();

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 50;
$offset = ($page - 1) * $limit;

$total = $db->count('upload_queue', 'admin_id = ?', 'i', [&$currentUser['id']]);
$totalPages = ceil($total / $limit);

$uploads = $db->fetchAll(
    "SELECT id, id_antrian, nama_barang, status, uploaded_at, completed_at, response_data 
     FROM upload_queue 
     WHERE admin_id = ? 
     ORDER BY uploaded_at DESC 
     LIMIT $limit OFFSET $offset",
    "i",
    [&$currentUser['id']]
);

ob_start();
?>

<div class="table-responsive">
    <table class="table table-hover">
        <thead>
            <tr>
                <th>ID Antrian</th>
                <th>Nama Produk</th>
                <th>Status</th>
                <th>Waktu Upload</th>
                <th>Waktu Selesai</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($uploads)): ?>
                <?php foreach ($uploads as $upload): ?>
                    <tr>
                        <td>
                            <small><code><?php echo htmlspecialchars(substr($upload['id_antrian'], 0, 12)); ?></code></small>
                        </td>
                        <td>
                            <small><?php echo htmlspecialchars(substr($upload['nama_barang'], 0, 40)); ?></small>
                        </td>
                        <td>
                            <?php
                            $statusClass = match($upload['status']) {
                                'pending' => 'warning',
                                'success' => 'success',
                                'failed' => 'danger',
                                default => 'secondary'
                            };
                            $statusText = match($upload['status']) {
                                'pending' => 'Menunggu',
                                'success' => 'Berhasil',
                                'failed' => 'Gagal',
                                default => $upload['status']
                            };
                            ?>
                            <span class="badge badge-<?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                        </td>
                        <td><small><?php echo date('d/m/Y H:i', strtotime($upload['uploaded_at'])); ?></small></td>
                        <td>
                            <small>
                                <?php 
                                if ($upload['completed_at']) {
                                    echo date('d/m/Y H:i', strtotime($upload['completed_at']));
                                } else {
                                    echo '-';
                                }
                                ?>
                            </small>
                        </td>
                        <td>
                            <button type="button" class="btn btn-sm btn-outline-info view-detail" 
                                    data-id="<?php echo $upload['id']; ?>" data-bs-toggle="modal" data-bs-target="#detailModal">
                                <i class="fas fa-eye"></i> Detail
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center py-4">
                        <div class="empty-state">
                            <i class="fas fa-inbox fa-2x text-muted mb-3 d-block"></i>
                            <p class="text-muted">Belum ada riwayat upload</p>
                        </div>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Pagination -->
<?php if ($totalPages > 1): ?>
    <nav aria-label="Page navigation" class="mt-3">
        <ul class="pagination justify-content-center">
            <li class="page-item <?php echo $page === 1 ? 'disabled' : ''; ?>">
                <a class="page-link" href="?page=1">First</a>
            </li>
            <?php for ($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
                <li class="page-item <?php echo $page === $i ? 'active' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                </li>
            <?php endfor; ?>
            <li class="page-item <?php echo $page === $totalPages ? 'disabled' : ''; ?>">
                <a class="page-link" href="?page=<?php echo $totalPages; ?>">Last</a>
            </li>
        </ul>
    </nav>
<?php endif; ?>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Upload</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <pre id="detailContent" style="background: #f8f9fa; padding: 15px; border-radius: 5px; max-height: 400px; overflow-y: auto;"></pre>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<script>
document.querySelectorAll('.view-detail').forEach(btn => {
    btn.addEventListener('click', async function() {
        const id = this.dataset.id;
        try {
            const response = await fetch('/api/get-upload-detail?id=' + id);
            const data = await response.json();
            if (data.success) {
                document.getElementById('detailContent').textContent = JSON.stringify(data.data, null, 2);
            }
        } catch (error) {
            console.error('Error:', error);
        }
    });
});
</script>

<?php
$content = ob_get_clean();
include '../includes/layout.php';
?>
