<?php
require_once '../includes/middleware.php';

$pageTitle = 'Profil';
$activePage = 'profil';

$db = Database::getInstance();

$user = $db->fetch(
    "SELECT id, username, email, created_at FROM admin_users WHERE id = ?",
    "i",
    [&$currentUser['id']]
);

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $oldPassword = $_POST['old_password'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';

    if ($newPassword !== $confirmPassword) {
        $message = '<div class="alert alert-danger">Password baru tidak cocok</div>';
    } elseif (strlen($newPassword) < 6) {
        $message = '<div class="alert alert-danger">Password minimal 6 karakter</div>';
    } else {
        $result = $auth->updatePassword($currentUser['id'], $oldPassword, $newPassword);
        if ($result['success']) {
            $message = '<div class="alert alert-success">' . $result['message'] . '</div>';
        } else {
            $message = '<div class="alert alert-danger">' . $result['message'] . '</div>';
        }
    }
}

ob_start();
?>

<div class="row">
    <div class="col-lg-4 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <div style="width: 80px; height: 80px; margin: 0 auto 15px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 32px;">
                    <i class="fas fa-user"></i>
                </div>
                <h5><?php echo htmlspecialchars($user['username']); ?></h5>
                <p class="text-muted"><?php echo htmlspecialchars($user['email']); ?></p>
                <small class="text-muted">Member sejak <?php echo date('d M Y', strtotime($user['created_at'])); ?></small>
            </div>
        </div>
    </div>

    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-lock"></i> Ubah Password</h5>
            </div>
            <div class="card-body">
                <?php echo $message; ?>
                
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Password Lama *</label>
                        <input type="password" class="form-control" name="old_password" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Password Baru *</label>
                        <input type="password" class="form-control" name="new_password" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Konfirmasi Password *</label>
                        <input type="password" class="form-control" name="confirm_password" required>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Ubah Password
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include '../includes/layout.php';
?>
