<?php
require_once '../includes/middleware.php';

$pageTitle = 'Kategori & Lokasi';
$activePage = 'kategori-lokasi';

$db = Database::getInstance();

// Get kategoribukuolshop
$kategoriBukaOlshop = [];
$lokasiBukaOlshop = [];

// Try to get from API
$result = $api->getKategoriDanLokasi(true); // Force refresh
if (isset($result['success']) && $result['success']) {
    $kategoriBukaOlshop = $result['data']['kategori'] ?? [];
    $lokasiBukaOlshop = $result['data']['lokasi'] ?? [];
}

// Get from local database
$kategoriBukaOlshopLocal = $db->fetchAll(
    "SELECT id_kategori, nama_kategori FROM kategori WHERE admin_id = ? ORDER BY nama_kategori",
    "i",
    [&$currentUser['id']]
);

$lokasiBukaOlshopLocal = $db->fetchAll(
    "SELECT id_lokasi, nama_pengirim, tipe_lokasi FROM lokasi WHERE admin_id = ? ORDER BY nama_pengirim",
    "i",
    [&$currentUser['id']]
);

ob_start();
?>

<div class="row">
    <div class="col-12">
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i>
            <strong>Sinkronisasi Data</strong><br>
            Tekan tombol "Sinkronisasi Sekarang" untuk mengambil data kategori dan lokasi terbaru dari BukaOlshop API.
        </div>
    </div>
</div>

<!-- Sync Button -->
<div class="row mb-3">
    <div class="col-12">
        <button class="btn btn-primary" id="syncBtn" onclick="syncKategoriLokasi()">
            <i class="fas fa-sync"></i> Sinkronisasi Sekarang
        </button>
        <small class="text-muted ms-2" id="syncStatus"></small>
    </div>
</div>

<!-- Kategori Section -->
<div class="row mb-4">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-tags"></i> Kategori (<?php echo count($kategoriBukaOlshopLocal); ?>)</h5>
                <input type="text" class="form-control form-control-sm" placeholder="Cari kategori..." 
                       style="width: auto; max-width: 200px;" onkeyup="filterTable('kategoriTable', this.value)">
            </div>
            <div class="card-body p-0">
                <?php if (!empty($kategoriBukaOlshopLocal)): ?>
                    <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                        <table class="table table-hover mb-0" id="kategoriTable">
                            <thead class="table-light sticky-top">
                                <tr>
                                    <th style="width: 60%">Nama Kategori</th>
                                    <th style="width: 40%">ID</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($kategoriBukaOlshopLocal as $kat): ?>
                                    <tr>
                                        <td>
                                            <small><?php echo htmlspecialchars($kat['nama_kategori']); ?></small>
                                        </td>
                                        <td>
                                            <small class="text-muted"><?php echo $kat['id_kategori']; ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="empty-state" style="padding: 40px;">
                        <i class="fas fa-inbox"></i>
                        <p class="text-muted mt-2">Belum ada kategori</p>
                        <p class="text-muted small">Tekan tombol Sinkronisasi untuk mengambil data</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Lokasi Section -->
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-map-marker-alt"></i> Lokasi (<?php echo count($lokasiBukaOlshopLocal); ?>)</h5>
                <input type="text" class="form-control form-control-sm" placeholder="Cari lokasi..." 
                       style="width: auto; max-width: 200px;" onkeyup="filterTable('lokasiTable', this.value)">
            </div>
            <div class="card-body p-0">
                <?php if (!empty($lokasiBukaOlshopLocal)): ?>
                    <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                        <table class="table table-hover mb-0" id="lokasiTable">
                            <thead class="table-light sticky-top">
                                <tr>
                                    <th style="width: 45%">Nama Lokasi</th>
                                    <th style="width: 30%">Tipe</th>
                                    <th style="width: 25%">ID</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($lokasiBukaOlshopLocal as $lok): ?>
                                    <tr>
                                        <td>
                                            <small><?php echo htmlspecialchars($lok['nama_pengirim']); ?></small>
                                        </td>
                                        <td>
                                            <small>
                                                <?php if ($lok['tipe_lokasi'] === 'digital'): ?>
                                                    <span class="badge badge-info">Digital</span>
                                                <?php else: ?>
                                                    <span class="badge badge-success">Fisik</span>
                                                <?php endif; ?>
                                            </small>
                                        </td>
                                        <td>
                                            <small class="text-muted"><?php echo $lok['id_lokasi']; ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="empty-state" style="padding: 40px;">
                        <i class="fas fa-inbox"></i>
                        <p class="text-muted mt-2">Belum ada lokasi</p>
                        <p class="text-muted small">Tekan tombol Sinkronisasi untuk mengambil data</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Info Card -->
<div class="row">
    <div class="col-12">
        <div class="card bg-light">
            <div class="card-body">
                <h6><i class="fas fa-info-circle"></i> Informasi Penting</h6>
                <ul class="small ps-3 mb-0">
                    <li>Data kategori dan lokasi diambil dari API BukaOlshop</li>
                    <li>Data akan di-cache selama 1 jam untuk mengurangi API calls</li>
                    <li>Gunakan fitur Clear Cache dari dashboard untuk refresh data lebih cepat</li>
                    <li>ID Kategori dan Lokasi diperlukan saat upload produk</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
function filterTable(tableId, searchTerm) {
    const table = document.getElementById(tableId);
    const rows = table.querySelectorAll('tbody tr');
    
    rows.forEach(row => {
        const text = row.textContent.toLowerCase();
        row.style.display = text.includes(searchTerm.toLowerCase()) ? '' : 'none';
    });
}

async function syncKategoriLokasi() {
    const btn = document.getElementById('syncBtn');
    const status = document.getElementById('syncStatus');
    
    btn.disabled = true;
    status.textContent = 'Sinkronisasi sedang berlangsung...';
    
    try {
        const response = await fetch('/api/sync-kategori-lokasi', {method: 'POST'});
        const data = await response.json();
        
        if (data.success) {
            showToast('Sinkronisasi berhasil: ' + data.message, 'success');
            setTimeout(() => location.reload(), 2000);
        } else {
            showToast(data.message || 'Sinkronisasi gagal', 'danger');
            status.textContent = 'Sinkronisasi gagal';
        }
    } catch (error) {
        showToast('Error: ' + error.message, 'danger');
        status.textContent = 'Error';
    } finally {
        btn.disabled = false;
    }
}
</script>

<?php
$content = ob_get_clean();
include '../includes/layout.php';
?>
