<?php
/**
 * Main Router File
 * Handles URL routing untuk aplikasi
 */

require_once '../config/config.php';

// Get current page from URL
$page = isset($_GET['page']) ? strtolower(preg_replace('/[^a-z0-9-]/', '', $_GET['page'])) : 'dashboard';

// Daftar halaman yang tersedia
$pages = [
    'dashboard' => '/public/dashboard.php',
    'daftar-produk' => '/public/daftar-produk.php',
    'upload-produk' => '/public/upload-produk.php',
    'kategori-lokasi' => '/public/kategori-lokasi.php',
    'riwayat-upload' => '/public/riwayat-upload.php',
    'profil' => '/public/profil.php',
    'setting' => '/public/setting.php',
    'login' => '/public/login.php',
    'logout' => '/public/logout.php',
];

// Default ke dashboard jika page tidak ditemukan
if (!isset($pages[$page])) {
    $page = 'dashboard';
}

$file = BASE_PATH . $pages[$page];

if (file_exists($file)) {
    require_once $file;
} else {
    http_response_code(404);
    echo "Page not found";
}
