<?php
require_once '../includes/middleware.php';

$pageTitle = 'Dashboard';
$activePage = 'dashboard';

$db = Database::getInstance();

// Get statistics
$totalProducts = $db->count('products', 'admin_id = ?', 'i', [&$currentUser['id']]);
$totalUploads = $db->count('upload_queue', 'admin_id = ?', 'i', [&$currentUser['id']]);
$pendingUploads = $db->count('upload_queue', 'admin_id = ? AND status = ?', 'is', [&$currentUser['id'], 'pending']);
$totalKategori = $db->count('kategori', 'admin_id = ?', 'i', [&$currentUser['id']]);

// Get recent uploads
$recentUploads = $db->fetchAll(
    "SELECT id_antrian, nama_barang, status, uploaded_at 
     FROM upload_queue 
     WHERE admin_id = ? 
     ORDER BY uploaded_at DESC 
     LIMIT 5",
    "i",
    [&$currentUser['id']]
);

// Get recent products
$recentProducts = $db->fetchAll(
    "SELECT id_barang, nama_barang, harga_barang, stok_barang, tanggal 
     FROM products 
     WHERE admin_id = ? 
     ORDER BY tanggal DESC 
     LIMIT 5",
    "i",
    [&$currentUser['id']]
);

ob_start();
?>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="card-text text-muted mb-1">Total Produk</p>
                        <h3 class="card-title mb-0" style="color: var(--primary);"><?php echo number_format($totalProducts); ?></h3>
                    </div>
                    <i class="fas fa-box fa-2x" style="color: rgba(102, 126, 234, 0.2);"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="card-text text-muted mb-1">Total Upload</p>
                        <h3 class="card-title mb-0" style="color: #17a2b8;"><?php echo number_format($totalUploads); ?></h3>
                    </div>
                    <i class="fas fa-cloud-upload-alt fa-2x" style="color: rgba(23, 162, 184, 0.2);"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="card-text text-muted mb-1">Pending Upload</p>
                        <h3 class="card-title mb-0" style="color: #ffc107;"><?php echo number_format($pendingUploads); ?></h3>
                    </div>
                    <i class="fas fa-hourglass-half fa-2x" style="color: rgba(255, 193, 7, 0.2);"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="card-text text-muted mb-1">Kategori</p>
                        <h3 class="card-title mb-0" style="color: #28a745;"><?php echo number_format($totalKategori); ?></h3>
                    </div>
                    <i class="fas fa-tags fa-2x" style="color: rgba(40, 167, 69, 0.2);"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-bolt"></i> Aksi Cepat</h5>
            </div>
            <div class="card-body">
                <div class="row g-2">
                    <div class="col-md-4 col-sm-6 col-12">
                        <a href="/upload-produk" class="btn btn-primary w-100">
                            <i class="fas fa-plus-circle"></i> Upload Produk Baru
                        </a>
                    </div>
                    <div class="col-md-4 col-sm-6 col-12">
                        <a href="/daftar-produk" class="btn btn-info w-100">
                            <i class="fas fa-list"></i> Lihat Daftar Produk
                        </a>
                    </div>
                    <div class="col-md-4 col-sm-6 col-12">
                        <a href="/kategori-lokasi" class="btn btn-success w-100">
                            <i class="fas fa-sync"></i> Sinkronisasi Kategori
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Uploads -->
<div class="row mb-4">
    <div class="col-lg-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-history"></i> Upload Terakhir</h5>
                <a href="/riwayat-upload" class="text-primary" style="font-size: 12px;">Lihat Semua</a>
            </div>
            <div class="card-body p-0">
                <?php if (!empty($recentUploads)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Produk</th>
                                    <th>Status</th>
                                    <th>Waktu</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentUploads as $upload): ?>
                                    <tr>
                                        <td>
                                            <small><?php echo htmlspecialchars(substr($upload['nama_barang'], 0, 30)); ?></small>
                                        </td>
                                        <td>
                                            <?php
                                            $statusClass = $upload['status'] === 'pending' ? 'warning' : 'success';
                                            $statusText = $upload['status'] === 'pending' ? 'Menunggu' : 'Selesai';
                                            ?>
                                            <span class="badge badge-<?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                                        </td>
                                        <td><small><?php echo date('d/m/Y H:i', strtotime($upload['uploaded_at'])); ?></small></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="empty-state" style="padding: 30px;">
                        <i class="fas fa-inbox"></i>
                        <h6>Belum ada upload</h6>
                        <p class="text-muted mb-2">Mulai upload produk Anda sekarang</p>
                        <a href="/upload-produk" class="btn btn-sm btn-primary">Upload Produk</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Recent Products -->
    <div class="col-lg-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-box"></i> Produk Terakhir</h5>
                <a href="/daftar-produk" class="text-primary" style="font-size: 12px;">Lihat Semua</a>
            </div>
            <div class="card-body p-0">
                <?php if (!empty($recentProducts)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Nama</th>
                                    <th>Harga</th>
                                    <th>Stok</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentProducts as $product): ?>
                                    <tr>
                                        <td><small><?php echo htmlspecialchars(substr($product['nama_barang'], 0, 25)); ?></small></td>
                                        <td><small>Rp<?php echo number_format($product['harga_barang'], 0, ',', '.'); ?></small></td>
                                        <td><small><?php echo $product['stok_barang']; ?> pcs</small></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="empty-state" style="padding: 30px;">
                        <i class="fas fa-inbox"></i>
                        <h6>Belum ada produk</h6>
                        <p class="text-muted mb-2">Mulai upload produk Anda sekarang</p>
                        <a href="/upload-produk" class="btn btn-sm btn-primary">Upload Produk</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Help Section -->
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);">
            <div class="card-body">
                <h5><i class="fas fa-info-circle"></i> Panduan Cepat</h5>
                <ul class="mb-0 ps-3">
                    <li>Gunakan fitur <strong>Upload Produk</strong> untuk menambah produk baru</li>
                    <li>Anda bisa upload satu per satu atau menggunakan file CSV untuk upload masal</li>
                    <li>Sinkronkan kategori dan lokasi dari <strong>Kategori & Lokasi</strong> untuk mendapatkan data terbaru</li>
                    <li>Gunakan <strong>Clear Cache</strong> untuk menghapus cache dan membuat request API baru</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include '../includes/layout.php';
?>
