<?php
require_once '../includes/middleware.php';

$pageTitle = 'Daftar Produk';
$activePage = 'daftar-produk';

$db = Database::getInstance();

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$search = isset($_GET['search']) ? $_GET['search'] : '';
$limit = ITEMS_PER_PAGE;
$offset = ($page - 1) * $limit;

// Build query
$whereClause = 'admin_id = ?';
$params = [&$currentUser['id']];
$types = 'i';

if (!empty($search)) {
    $whereClause .= ' AND nama_barang LIKE ?';
    $searchParam = '%' . $search . '%';
    $params[] = &$searchParam;
    $types .= 's';
}

// Get total
$total = $db->count('products', $whereClause, $types, $params);
$totalPages = ceil($total / $limit);

// Get products
$query = "SELECT id_barang, id_kategori, nama_barang, harga_barang, harga_barang_asli, stok_barang, tanggal 
          FROM products 
          WHERE $whereClause 
          ORDER BY tanggal DESC 
          LIMIT $limit OFFSET $offset";

$params2 = array_slice($params, 0, -1);
if (!empty($search)) {
    $products = $db->fetchAll($query, $types, $params);
} else {
    $products = $db->fetchAll(
        "SELECT id_barang, id_kategori, nama_barang, harga_barang, harga_barang_asli, stok_barang, tanggal 
         FROM products 
         WHERE admin_id = ? 
         ORDER BY tanggal DESC 
         LIMIT $limit OFFSET $offset",
        'i',
        [&$currentUser['id']]
    );
}

ob_start();
?>

<!-- Search Bar -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" class="d-flex gap-2">
            <input type="text" name="search" class="form-control" placeholder="Cari nama produk..." 
                   value="<?php echo htmlspecialchars($search); ?>">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Cari
            </button>
            <?php if (!empty($search)): ?>
                <a href="/daftar-produk" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Reset
                </a>
            <?php endif; ?>
        </form>
    </div>
</div>

<!-- Products Table -->
<div class="table-responsive">
    <table class="table table-hover">
        <thead>
            <tr>
                <th style="width: 5%">No</th>
                <th>Nama Produk</th>
                <th style="width: 12%">Harga</th>
                <th style="width: 8%">Stok</th>
                <th style="width: 12%">ID Barang</th>
                <th style="width: 12%">Kategori</th>
                <th style="width: 15%">Tanggal</th>
                <th style="width: 15%">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($products)): ?>
                <?php foreach ($products as $index => $product): 
                    $no = $offset + $index + 1;
                    $hargaDisplay = $product['harga_barang_asli'] ? 
                        '<small class="text-muted"><s>Rp' . number_format($product['harga_barang_asli'], 0, ',', '.') . '</s></small><br>' : '';
                    $hargaDisplay .= 'Rp' . number_format($product['harga_barang'], 0, ',', '.');
                ?>
                    <tr data-id="<?php echo $product['id_barang']; ?>">
                        <td><?php echo $no; ?></td>
                        <td>
                            <strong><?php echo htmlspecialchars(substr($product['nama_barang'], 0, 50)); ?></strong>
                            <?php if (strlen($product['nama_barang']) > 50): ?>
                                <br><small class="text-muted">...</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="harga-display"><?php echo $hargaDisplay; ?></div>
                            <input type="hidden" class="harga-barang" value="<?php echo $product['harga_barang']; ?>">
                            <input type="hidden" class="harga-barang-asli" value="<?php echo $product['harga_barang_asli']; ?>">
                            <div class="harga-edit" style="display: none;">
                                <div class="input-group input-group-sm">
                                    <input type="number" class="form-control harga-input" value="<?php echo $product['harga_barang']; ?>">
                                    <button class="btn btn-sm btn-outline-success save-harga" type="button">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="stok-display"><?php echo $product['stok_barang']; ?> pcs</div>
                            <input type="hidden" class="stok-barang" value="<?php echo $product['stok_barang']; ?>">
                            <div class="stok-edit" style="display: none;">
                                <input type="number" class="form-control form-control-sm stok-input" value="<?php echo $product['stok_barang']; ?>" min="0">
                            </div>
                        </td>
                        <td><small><?php echo $product['id_barang']; ?></small></td>
                        <td><small><?php echo $product['id_kategori']; ?></small></td>
                        <td><small><?php echo date('d/m/Y H:i', strtotime($product['tanggal'])); ?></small></td>
                        <td>
                            <div class="action-buttons">
                                <button type="button" class="btn btn-sm btn-outline-primary edit-btn" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-danger delete-btn" title="Hapus">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                            <div class="action-save" style="display: none; gap: 5px; display: flex;">
                                <button type="button" class="btn btn-sm btn-success save-btn" title="Simpan">
                                    <i class="fas fa-check"></i> Simpan
                                </button>
                                <button type="button" class="btn btn-sm btn-secondary cancel-btn" title="Batal">
                                    <i class="fas fa-times"></i> Batal
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" class="text-center py-4">
                        <div class="empty-state">
                            <i class="fas fa-inbox fa-2x text-muted mb-3 d-block"></i>
                            <p class="text-muted">Belum ada produk</p>
                            <a href="/upload-produk" class="btn btn-sm btn-primary">Upload Produk</a>
                        </div>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Pagination -->
<?php if ($totalPages > 1): ?>
    <nav aria-label="Page navigation" class="mt-3">
        <ul class="pagination justify-content-center">
            <li class="page-item <?php echo $page === 1 ? 'disabled' : ''; ?>">
                <a class="page-link" href="?page=1<?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>">
                    <i class="fas fa-step-backward"></i>
                </a>
            </li>
            
            <?php for ($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
                <li class="page-item <?php echo $page === $i ? 'active' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>">
                        <?php echo $i; ?>
                    </a>
                </li>
            <?php endfor; ?>
            
            <li class="page-item <?php echo $page === $totalPages ? 'disabled' : ''; ?>">
                <a class="page-link" href="?page=<?php echo $totalPages; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>">
                    <i class="fas fa-step-forward"></i>
                </a>
            </li>
        </ul>
    </nav>
    <div class="text-center text-muted mb-2">
        <small>Halaman <?php echo $page; ?> dari <?php echo $totalPages; ?> (Total: <?php echo $total; ?> produk)</small>
    </div>
<?php endif; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Edit button handler
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const row = this.closest('tr');
            row.querySelector('.action-buttons').style.display = 'none';
            row.querySelector('.action-save').style.display = 'flex';
            row.querySelector('.harga-display').style.display = 'none';
            row.querySelector('.harga-edit').style.display = 'block';
            row.querySelector('.stok-display').style.display = 'none';
            row.querySelector('.stok-edit').style.display = 'block';
        });
    });

    // Cancel button handler
    document.querySelectorAll('.cancel-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const row = this.closest('tr');
            row.querySelector('.action-buttons').style.display = 'block';
            row.querySelector('.action-save').style.display = 'none';
            row.querySelector('.harga-display').style.display = 'block';
            row.querySelector('.harga-edit').style.display = 'none';
            row.querySelector('.stok-display').style.display = 'block';
            row.querySelector('.stok-edit').style.display = 'none';
        });
    });

    // Save button handler
    document.querySelectorAll('.save-btn').forEach(btn => {
        btn.addEventListener('click', async function() {
            const row = this.closest('tr');
            const idBarang = row.dataset.id;
            const harga = row.querySelector('.harga-input').value;
            const stok = row.querySelector('.stok-input').value;

            if (!harga || !stok) {
                showToast('Harga dan stok wajib diisi', 'danger');
                return;
            }

            try {
                const response = await fetch('/api/edit-produk', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        id_barang: idBarang,
                        harga_barang: parseInt(harga),
                        jumlah_stok: parseInt(stok)
                    })
                });

                const data = await response.json();
                if (data.success) {
                    showToast('Produk berhasil diupdate', 'success');
                    row.querySelector('.action-buttons').style.display = 'block';
                    row.querySelector('.action-save').style.display = 'none';
                    row.querySelector('.harga-display').style.display = 'block';
                    row.querySelector('.harga-edit').style.display = 'none';
                    row.querySelector('.stok-display').style.display = 'block';
                    row.querySelector('.stok-edit').style.display = 'none';
                } else {
                    showToast(data.message || 'Gagal update produk', 'danger');
                }
            } catch (error) {
                showToast('Error: ' + error.message, 'danger');
            }
        });
    });

    // Delete button handler
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', async function() {
            const row = this.closest('tr');
            const idBarang = row.dataset.id;
            const namaProduk = row.querySelector('td:nth-child(2)').textContent.trim();

            if (!confirm(`Yakin ingin menghapus "${namaProduk}"?`)) return;

            try {
                const response = await fetch('/api/delete-produk', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({id_barang: idBarang})
                });

                const data = await response.json();
                if (data.success) {
                    showToast('Produk berhasil dihapus', 'success');
                    row.remove();
                } else {
                    showToast(data.message || 'Gagal hapus produk', 'danger');
                }
            } catch (error) {
                showToast('Error: ' + error.message, 'danger');
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
include '../includes/layout.php';
?>
