<?php
/**
 * Middleware untuk authentication check
 */

require_once dirname(__DIR__) . '/config/config.php';

$auth = new Auth();

// Check if user is logged in
if (!$auth->isLoggedIn()) {
    header('Location: /login');
    exit;
}

// Get current user
$currentUser = $auth->getCurrentUser();
if (!$currentUser) {
    header('Location: /login');
    exit;
}

// Initialize API
$api = new BukaOlshopAPI($currentUser['api_key'], $currentUser['id']);
