<?php
/**
 * Main Layout Template
 */
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle ?? 'BukaOlshop Admin'); ?> - BukaOlshop Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #667eea;
            --secondary: #764ba2;
            --success: #28a745;
            --danger: #dc3545;
            --warning: #ffc107;
            --info: #17a2b8;
            --light: #f8f9fa;
            --dark: #333;
            --border: #dee2e6;
        }

        html, body {
            height: 100%;
            background-color: #f5f6f7;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            display: flex;
        }

        /* Sidebar */
        .sidebar {
            width: 260px;
            background: white;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.05);
            position: fixed;
            height: 100vh;
            left: 0;
            top: 0;
            overflow-y: auto;
            z-index: 1000;
            transition: all 0.3s ease;
        }

        .sidebar-header {
            padding: 25px 20px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar-header h4 {
            margin: 0;
            font-size: 18px;
            font-weight: 700;
        }

        .sidebar-header p {
            margin: 5px 0 0;
            font-size: 12px;
            opacity: 0.9;
        }

        .sidebar-menu {
            padding: 20px 0;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #555;
            text-decoration: none;
            transition: all 0.3s ease;
            border-left: 3px solid transparent;
            position: relative;
        }

        .sidebar-menu a:hover {
            background-color: #f8f9fa;
            color: var(--primary);
            border-left-color: var(--primary);
        }

        .sidebar-menu a.active {
            background-color: #f0f2f5;
            color: var(--primary);
            border-left-color: var(--primary);
            font-weight: 600;
        }

        .sidebar-menu i {
            width: 20px;
            margin-right: 12px;
            text-align: center;
        }

        .sidebar-divider {
            height: 1px;
            background-color: var(--border);
            margin: 15px 0;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 260px;
            padding: 20px;
            overflow-y: auto;
        }

        /* Top Navigation */
        .top-nav {
            background: white;
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .top-nav h2 {
            margin: 0;
            font-size: 24px;
            color: var(--dark);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-menu .btn {
            font-size: 14px;
            padding: 8px 15px;
        }

        /* Content Area */
        .content {
            background: white;
            border-radius: 8px;
            padding: 25px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }

        /* Cards */
        .card {
            border: 1px solid var(--border);
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }

        .card:hover {
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid var(--border);
            font-weight: 600;
        }

        /* Tables */
        .table {
            margin-bottom: 0;
        }

        .table thead th {
            background-color: #f8f9fa;
            font-weight: 600;
            border-bottom: 2px solid var(--border);
            vertical-align: middle;
        }

        .table tbody td {
            vertical-align: middle;
            padding: 12px 15px;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
        }

        /* Forms */
        .form-control, .form-select {
            border: 1px solid var(--border);
            border-radius: 6px;
            padding: 10px 12px;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }

        .form-label {
            font-weight: 600;
            margin-bottom: 8px;
            color: #333;
        }

        /* Buttons */
        .btn {
            border-radius: 6px;
            font-weight: 500;
            transition: all 0.3s ease;
            border: none;
            padding: 10px 15px;
            font-size: 14px;
        }

        .btn-primary {
            background-color: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background-color: #5568d3;
            color: white;
            transform: translateY(-2px);
        }

        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }

        .btn-secondary:hover {
            background-color: #5a6268;
            color: white;
        }

        .btn-success {
            background-color: var(--success);
            color: white;
        }

        .btn-danger {
            background-color: var(--danger);
            color: white;
        }

        .btn-warning {
            background-color: var(--warning);
            color: #333;
        }

        .btn-sm {
            padding: 6px 10px;
            font-size: 12px;
        }

        /* Badges */
        .badge {
            padding: 6px 10px;
            font-size: 12px;
            font-weight: 500;
            border-radius: 4px;
        }

        .badge-success {
            background-color: #d4edda;
            color: #155724;
        }

        .badge-danger {
            background-color: #f8d7da;
            color: #721c24;
        }

        .badge-warning {
            background-color: #fff3cd;
            color: #856404;
        }

        .badge-info {
            background-color: #d1ecf1;
            color: #0c5460;
        }

        /* Alerts */
        .alert {
            border: none;
            border-radius: 6px;
            border-left: 4px solid;
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border-left-color: #28a745;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border-left-color: #dc3545;
        }

        .alert-warning {
            background-color: #fff3cd;
            color: #856404;
            border-left-color: #ffc107;
        }

        .alert-info {
            background-color: #d1ecf1;
            color: #0c5460;
            border-left-color: #17a2b8;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                width: 0;
                left: -260px;
            }

            .sidebar.show {
                left: 0;
                box-shadow: 2px 0 10px rgba(0, 0, 0, 0.2);
            }

            .main-content {
                margin-left: 0;
                padding: 15px;
            }

            .top-nav {
                padding: 10px 15px;
                margin-bottom: 15px;
            }

            .top-nav h2 {
                font-size: 20px;
            }

            .content {
                padding: 15px;
            }

            .table {
                font-size: 13px;
            }

            .table tbody td {
                padding: 8px 10px;
            }
        }

        /* Loading Spinner */
        .spinner-border {
            border-width: 0.3em;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 50px 20px;
            color: #6c757d;
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 15px;
            opacity: 0.5;
        }

        .empty-state h4 {
            margin-bottom: 10px;
            color: #333;
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h4><i class="fas fa-shopping-cart"></i> BukaOlshop</h4>
            <p><?php echo htmlspecialchars($currentUser['username'] ?? 'Admin'); ?></p>
        </div>

        <div class="sidebar-menu">
            <a href="/dashboard" class="<?php echo isset($activePage) && $activePage === 'dashboard' ? 'active' : ''; ?>">
                <i class="fas fa-home"></i> Dashboard
            </a>
            <a href="/daftar-produk" class="<?php echo isset($activePage) && $activePage === 'daftar-produk' ? 'active' : ''; ?>">
                <i class="fas fa-list"></i> Daftar Produk
            </a>
            <a href="/upload-produk" class="<?php echo isset($activePage) && $activePage === 'upload-produk' ? 'active' : ''; ?>">
                <i class="fas fa-upload"></i> Upload Produk
            </a>
            <a href="/kategori-lokasi" class="<?php echo isset($activePage) && $activePage === 'kategori-lokasi' ? 'active' : ''; ?>">
                <i class="fas fa-tags"></i> Kategori & Lokasi
            </a>

            <div class="sidebar-divider"></div>

            <a href="#" class="<?php echo isset($activePage) && $activePage === 'riwayat' ? 'active' : ''; ?>">
                <i class="fas fa-history"></i> Riwayat Upload
            </a>

            <div class="sidebar-divider"></div>

            <a href="/logout" onclick="return confirm('Yakin ingin logout?')">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
    </div>

    <!-- Mobile Menu Toggle -->
    <button class="btn btn-primary d-lg-none position-fixed" style="bottom: 20px; right: 20px; z-index: 999; border-radius: 50%; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;" id="menuToggle">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navigation -->
        <div class="top-nav">
            <h2><?php echo htmlspecialchars($pageTitle ?? 'Dashboard'); ?></h2>
            <div class="user-menu">
                <button class="btn btn-outline-secondary btn-sm" onclick="clearCache()">
                    <i class="fas fa-trash"></i> Clear Cache
                </button>
                <div class="dropdown">
                    <button class="btn btn-light dropdown-toggle btn-sm" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user"></i> <?php echo htmlspecialchars($currentUser['username'] ?? 'User'); ?>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="/profil">Profil</a></li>
                        <li><a class="dropdown-item" href="/setting">Pengaturan</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-danger" href="/logout" onclick="return confirm('Yakin ingin logout?')">Logout</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Page Content -->
        <div class="content">
            <?php echo isset($content) ? $content : ''; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script>
        // Mobile menu toggle
        document.getElementById('menuToggle')?.addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Close sidebar when clicking outside
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const menuToggle = document.getElementById('menuToggle');
            if (!sidebar.contains(event.target) && !menuToggle.contains(event.target) && window.innerWidth <= 768) {
                sidebar.classList.remove('show');
            }
        });

        // Clear cache function
        function clearCache() {
            if (confirm('Yakin ingin menghapus cache? Ini akan membuat request API baru.')) {
                fetch('/api/clear-cache', {method: 'POST'})
                    .then(r => r.json())
                    .then(data => {
                        if (data.success) {
                            Toastify({
                                text: 'Cache berhasil dihapus',
                                duration: 3000,
                                gravity: 'top',
                                position: 'right',
                                backgroundColor: '#28a745'
                            }).showToast();
                        }
                    });
            }
        }

        // Show toast notifications
        function showToast(message, type = 'success', duration = 3000) {
            const colors = {
                success: '#28a745',
                danger: '#dc3545',
                warning: '#ffc107',
                info: '#17a2b8'
            };
            
            Toastify({
                text: message,
                duration: duration,
                gravity: 'top',
                position: 'right',
                backgroundColor: colors[type] || colors.success
            }).showToast();
        }
    </script>
</body>
</html>
