<?php
/**
 * Configuration File untuk BukaOlshop Admin System
 */

// Define Base Path
define('BASE_PATH', dirname(dirname(__FILE__)));
define('APP_URL', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http' . '://' . $_SERVER['HTTP_HOST']);

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'mitragra_create_produk');
define('DB_PASS', 'aBYd^!k%7-J&(n~2');
define('DB_NAME', 'mitragra_create_produk');
define('DB_PORT', 3306);
define('DB_CHARSET', 'utf8mb4');

// API Configuration
define('BUKAOLSHOP_API_BASE', 'https://bukaolshop.net/api/v1');
define('API_TIMEOUT', 30);
define('API_CACHE_DURATION', 3600); // 1 hour

// Session Configuration
define('SESSION_TIMEOUT', 3600); // 1 hour
define('SESSION_NAME', 'bukaolshop_admin_session');

// Upload Configuration
define('UPLOAD_DIR', BASE_PATH . '/uploads');
define('MAX_FILE_SIZE', 10485760); // 10MB
define('ALLOWED_EXTENSIONS', ['csv', 'xlsx', 'xls']);

// Security
define('CSRF_TOKEN_NAME', 'csrf_token');
define('CSRF_TOKEN_EXPIRY', 3600);

// Pagination
define('ITEMS_PER_PAGE', 20);

// Enable error reporting (disable in production)
define('DEBUG_MODE', false);

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', BASE_PATH . '/logs/error.log');
}

// Timezone
date_default_timezone_set('Asia/Jakarta');

// Load Environment Variables (jika menggunakan .env)
function loadEnv($file) {
    if (!file_exists($file)) return;
    
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '=') === false) continue;
        if (strpos($line, '#') === 0) continue;
        
        list($key, $value) = explode('=', $line, 2);
        $key = trim($key);
        $value = trim($value);
        
        if (!empty($key)) {
            putenv("{$key}={$value}");
        }
    }
}

// Create necessary directories
if (!is_dir(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}
if (!is_dir(BASE_PATH . '/logs')) {
    mkdir(BASE_PATH . '/logs', 0755, true);
}

// Auto-load classes
spl_autoload_register(function($class) {
    $path = BASE_PATH . '/classes/' . str_replace('\\', '/', $class) . '.php';
    if (file_exists($path)) {
        require_once $path;
    }
});

// Start session jika belum ada
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}
