<?php
require_once '../includes/middleware.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $products = $input['products'] ?? [];

    if (empty($products)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Tidak ada produk']);
        exit;
    }

    $successCount = 0;
    $errors = [];

    foreach ($products as $index => $product) {
        // Validasi
        if (empty($product['id_kategori']) || empty($product['id_lokasi'])) {
            $errors[] = "Produk " . ($index + 1) . ": kategori dan lokasi wajib diisi";
            continue;
        }

        // Upload via API
        $result = $api->uploadProduk($product);

        if ($result['success']) {
            $successCount++;
        } else {
            $errors[] = "Produk " . ($index + 1) . ": " . $result['message'];
        }
    }

    echo json_encode([
        'success' => true,
        'count' => $successCount,
        'total' => count($products),
        'errors' => $errors
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
