<?php
require_once '../includes/middleware.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    if (!isset($_FILES['csv_file'])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'File tidak ditemukan']);
        exit;
    }

    $file = $_FILES['csv_file'];
    
    // Validasi file
    if ($file['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Error upload file: ' . $file['error']);
    }

    if ($file['size'] > MAX_FILE_SIZE) {
        throw new Exception('File terlalu besar (max ' . MAX_FILE_SIZE/1024/1024 . 'MB)');
    }

    // Validasi tipe file
    $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
    if (!in_array(strtolower($ext), ALLOWED_EXTENSIONS)) {
        throw new Exception('Tipe file tidak didukung');
    }

    // Simpan temporary
    $tempFile = UPLOAD_DIR . '/temp_' . uniqid() . '.csv';
    if (!move_uploaded_file($file['tmp_name'], $tempFile)) {
        throw new Exception('Gagal menyimpan file');
    }

    // Parse CSV
    $csvHandler = new CSVHandler($tempFile);
    if (!$csvHandler->parse()) {
        throw new Exception('Gagal membaca CSV: ' . implode(', ', $csvHandler->getErrors()));
    }

    // Validasi data
    if (!$csvHandler->validate()) {
        unlink($tempFile);
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Validasi CSV gagal',
            'errors' => $csvHandler->getErrors()
        ]);
        exit;
    }

    $data = $csvHandler->getData();
    $successCount = 0;
    $errors = [];

    foreach ($data as $index => $row) {
        // Upload produk
        $result = $api->uploadProduk($row);

        if ($result['success']) {
            $successCount++;
        } else {
            $errors[] = "Baris " . ($index + 2) . ": " . $result['message'];
        }
    }

    // Hapus temp file
    unlink($tempFile);

    echo json_encode([
        'success' => true,
        'count' => $successCount,
        'total' => count($data),
        'errors' => $errors
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
