<?php
require_once '../includes/middleware.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Force refresh dari API
    $result = $api->getKategoriDanLokasi(true);

    if (isset($result['success']) && $result['success']) {
        echo json_encode([
            'success' => true,
            'message' => count($result['data']['kategori'] ?? []) . ' kategori dan ' . 
                        count($result['data']['lokasi'] ?? []) . ' lokasi berhasil disinkronisasi'
        ]);
    } else {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => $result['message'] ?? 'Sinkronisasi gagal']);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
