<?php
require_once '../includes/middleware.php';

header('Content-Type: application/json');

try {
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'ID tidak valid']);
        exit;
    }

    $db = Database::getInstance();
    
    $upload = $db->fetch(
        "SELECT id, id_antrian, nama_barang, status, uploaded_at, completed_at, response_data 
         FROM upload_queue 
         WHERE id = ? AND admin_id = ?",
        "ii",
        [&$id, &$currentUser['id']]
    );

    if (!$upload) {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'Upload tidak ditemukan']);
        exit;
    }

    $upload['response_data'] = json_decode($upload['response_data'], true);

    echo json_encode(['success' => true, 'data' => $upload]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
