<?php
require_once '../includes/middleware.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $idBarang = $input['id_barang'] ?? '';

    if (empty($idBarang)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'ID barang wajib diisi']);
        exit;
    }

    // Prepare data for update
    $updateData = [];
    $allowedFields = ['harga_barang', 'jumlah_stok', 'nama_barang', 'deskripsi_singkat', 'deskripsi_panjang'];
    
    foreach ($allowedFields as $field) {
        if (isset($input[$field])) {
            $updateData[$field] = $input[$field];
        }
    }

    // Update di database lokal
    $db = Database::getInstance();
    $db->update('products', $updateData, 'id_barang = ?', 's', [&$idBarang]);

    // Update via API BukaOlshop (jika ada)
    // Tapi kita perlu field yang sesuai untuk API
    $apiUpdateData = ['id_barang' => $idBarang];
    
    if (isset($input['harga_barang'])) $apiUpdateData['harga_barang'] = $input['harga_barang'];
    if (isset($input['jumlah_stok'])) $apiUpdateData['jumlah_stok'] = $input['jumlah_stok'];
    if (isset($input['nama_barang'])) $apiUpdateData['nama_barang'] = $input['nama_barang'];

    $apiResult = $api->editProduk($apiUpdateData);

    // Clear cache
    $api->clearUploadCache();

    echo json_encode(['success' => true, 'message' => 'Produk berhasil diupdate']);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
