<?php
require_once '../includes/middleware.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $idBarang = $input['id_barang'] ?? '';

    if (empty($idBarang)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'ID barang wajib diisi']);
        exit;
    }

    // Delete dari database lokal
    $db = Database::getInstance();
    $db->delete('products', 'id_barang = ? AND admin_id = ?', 'si', [&$idBarang, &$currentUser['id']]);

    // Log activity
    $db->insert('activity_log', [
        'admin_id' => $currentUser['id'],
        'action' => 'DELETE_PRODUCT',
        'description' => 'Produk ' . $idBarang . ' dihapus',
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'created_at' => date('Y-m-d H:i:s')
    ]);

    echo json_encode(['success' => true, 'message' => 'Produk berhasil dihapus']);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
