<?php
require_once '../includes/middleware.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    // Clear cache
    $cache = new Cache($currentUser['id']);
    $cache->clearAll();

    // Log activity
    $db = Database::getInstance();
    $db->insert('activity_log', [
        'admin_id' => $currentUser['id'],
        'action' => 'CLEAR_CACHE',
        'description' => 'Cache dihapus',
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'created_at' => date('Y-m-d H:i:s')
    ]);

    echo json_encode(['success' => true, 'message' => 'Cache berhasil dihapus']);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
