# BukaOlshop Admin System

Sistem manajemen produk untuk BukaOlshop dengan fitur upload masal, manajemen produk, dan sinkronisasi data.

## Fitur

✅ **Authentication System**
- Login dengan username dan password
- Session management dengan security
- Activity logging

✅ **Upload Produk**
- Upload manual (satu per satu)
- Upload CSV untuk masal
- Download template CSV
- Validasi data otomatis
- Queue system untuk upload

✅ **Manajemen Produk**
- Daftar produk dengan search dan pagination
- Edit produk secara inline
- Delete produk
- View detail produk

✅ **Kategori & Lokasi**
- Sinkronisasi data dari BukaOlshop API
- Search dan filter
- Caching system untuk performa

✅ **Dashboard**
- Statistik produk dan upload
- Quick actions
- Recent uploads dan products
- Activity history

✅ **API Integration**
- BukaOlshop API integration
- Error handling
- Response caching
- Request limiting

## Persyaratan

- PHP 7.4 atau lebih baru
- MySQL 5.7 atau lebih baru
- Apache dengan mod_rewrite enabled
- cURL extension

## Instalasi

### 1. Setup Database

```bash
# Import schema database
mysql -u root -p bukaolshop_admin < database/schema.sql
```

### 2. Konfigurasi

Edit file `/config/config.php`:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', 'password');
define('DB_NAME', 'bukaolshop_admin');
```

### 3. Upload ke Hosting

```bash
# Copy semua file ke hosting
# Pastikan folder uploads dan logs dapat ditulis (chmod 755)
```

### 4. Access Application

```
http://yourdomain.com/public/login

Demo Account:
Username: admin
Password: admin123
```

## Struktur Folder

```
/
├── api/                      # API endpoints
│   ├── upload-produk.php
│   ├── upload-csv.php
│   ├── edit-produk.php
│   ├── delete-produk.php
│   ├── clear-cache.php
│   ├── sync-kategori-lokasi.php
│   └── download-template.php
├── classes/                  # Core classes
│   ├── Database.php
│   ├── Auth.php
│   ├── BukaOlshopAPI.php
│   ├── Cache.php
│   └── CSVHandler.php
├── config/                   # Configuration
│   └── config.php
├── database/                 # Database scripts
│   └── schema.sql
├── includes/                 # Helpers & layout
│   ├── middleware.php
│   └── layout.php
├── public/                   # Public pages
│   ├── index.php
│   ├── login.php
│   ├── dashboard.php
│   ├── upload-produk.php
│   ├── daftar-produk.php
│   ├── kategori-lokasi.php
│   ├── riwayat-upload.php
│   ├── logout.php
│   └── .htaccess
├── uploads/                  # Folder untuk upload files
└── logs/                     # Error logs
```

## Konfigurasi BukaOlshop API

1. Buka aplikasi BukaOlshop di Android
2. Generate API Key di menu pengaturan
3. Copy API Key
4. Login ke admin panel
5. Masukkan API Key saat membuat akun admin

## Fitur Khusus

### Upload CSV

Format CSV yang benar:

```csv
id_kategori,id_lokasi,jenis_barang,nama_barang,deskripsi_singkat,deskripsi_panjang,harga_barang,stok_barang,url_gambar_barang_1
26324,18696,digital,Produk Digital,Deskripsi singkat,Deskripsi panjang,23000,100,https://example.com/image.jpg
```

Download template dari aplikasi untuk melihat format lengkap.

### Caching System

- Kategori & Lokasi di-cache selama 1 jam
- Produk list di-cache per halaman
- Clear Cache dari dashboard untuk refresh manual
- Auto cleanup expired cache

### Security

- Semua input di-sanitize
- CSRF token protection
- Password hashing dengan bcrypt
- SQL injection prevention dengan prepared statements
- Session timeout 1 jam
- IP address validation

## Troubleshooting

### Error: Database Connection Refused

```
✓ Check database credentials di config.php
✓ Pastikan MySQL running
✓ Pastikan user punya akses ke database
```

### Error: Uploads folder not writable

```bash
chmod 755 uploads/
chmod 755 logs/
```

### Error: .htaccess not working

```
✓ Enable mod_rewrite: a2enmod rewrite
✓ Restart Apache: service apache2 restart
```

### API Key tidak valid

```
✓ Generate API Key baru di aplikasi BukaOlshop
✓ Pastikan tidak ada space di awal/akhir
✓ Check API Key di dashboard
```

## Tips & Tricks

1. **Batch Upload**
   - Gunakan CSV untuk upload banyak produk sekaligus
   - Validasi file sebelum upload
   - Check error message jika ada yang gagal

2. **Performance**
   - Clear cache secara berkala
   - Gunakan pagination untuk produk list
   - Search untuk filter produk spesifik

3. **Backup**
   - Backup database secara berkala
   - Simpan export CSV produk
   - Catat API Key Anda

## API Documentation

### POST /api/upload-produk
Upload produk manual

**Request:**
```json
{
  "products": [
    {
      "id_kategori": "26324",
      "id_lokasi": "18696",
      "jenis_barang": "digital",
      "nama_barang": "Produk Digital",
      "deskripsi_singkat": "Deskripsi singkat",
      "deskripsi_panjang": "Deskripsi panjang",
      "harga_barang": "23000",
      "stok_barang": "100",
      "url_gambar_barang_1": "https://example.com/image.jpg"
    }
  ]
}
```

### POST /api/upload-csv
Upload produk dari CSV file

**Request:** multipart/form-data
- csv_file: file CSV

### POST /api/edit-produk
Edit produk

**Request:**
```json
{
  "id_barang": "563226",
  "harga_barang": "25000",
  "jumlah_stok": "50"
}
```

### POST /api/delete-produk
Delete produk

**Request:**
```json
{
  "id_barang": "563226"
}
```

### POST /api/clear-cache
Clear semua cache

## Support

Untuk bantuan, hubungi support atau buka dokumentasi BukaOlshop API.

## License

Proprietary - BukaOlshop Admin System
