# Panduan Instalasi - BukaOlshop Admin System

## Persyaratan Minimum

- **Server:** Apache/Nginx dengan PHP 7.4+
- **Database:** MySQL 5.7+ atau MariaDB 10.3+
- **Extensions:** cURL, MySQLi, JSON
- **Storage:** Minimal 100MB free space
- **Bandwidth:** Koneksi internet stabil

## Step 1: Persiapan File

### Via FTP/SFTP:
1. Upload semua file ke hosting (pastikan structure folder sama)
2. Set folder permissions:
   ```
   chmod 755 /
   chmod 755 public/
   chmod 755 uploads/
   chmod 755 logs/
   chmod 644 public/.htaccess
   ```

### Via SSH:
```bash
# Download file
git clone <repository-url> bukaolshop-admin
cd bukaolshop-admin

# Set permissions
chmod 755 uploads/
chmod 755 logs/
chmod 644 public/.htaccess
```

## Step 2: Setup Database

### Method 1: PhpMyAdmin

1. Login ke PhpMyAdmin
2. Create database baru dengan nama: `bukaolshop_admin`
3. Select database
4. Go to SQL tab
5. Copy-paste isi file `/database/schema.sql`
6. Execute

### Method 2: Command Line

```bash
mysql -h localhost -u root -p < database/schema.sql
```

**Catatan:** Ganti `root` dengan username MySQL Anda

### Method 3: cPanel

1. Login cPanel
2. Go to "MySQL Databases"
3. Create database `bukaolshop_admin`
4. Create user dengan password
5. Add user ke database dengan ALL PRIVILEGES
6. Go to "phpMyAdmin"
7. Select database
8. Import file `/database/schema.sql`

## Step 3: Konfigurasi

### Edit file `/config/config.php`

Cari section "Database Configuration":

```php
define('DB_HOST', 'localhost');      // Host database
define('DB_USER', 'root');           // Username database
define('DB_PASS', '');               // Password database
define('DB_NAME', 'bukaolshop_admin'); // Nama database
define('DB_PORT', 3306);             // Port database
```

**Contoh konfigurasi dengan password:**
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'bukaolshop');
define('DB_PASS', 'SecurePassword123');
define('DB_NAME', 'bukaolshop_admin');
define('DB_PORT', 3306);
```

## Step 4: Konfigurasi Apache (Important!)

### Enable .htaccess

Pastikan file `/public/.htaccess` sudah di-upload dan Apache mod_rewrite enabled.

**Untuk cPanel:**
1. Login cPanel
2. Go to "Mod Security/easyApache"
3. Check "Mod Rewrite" enabled
4. Restart Apache

**Untuk VPS/Dedicated:**
```bash
sudo a2enmod rewrite
sudo systemctl restart apache2
```

### Document Root

Pastikan Document Root pointing ke folder `/public`:

**Jika bisa set document root:**
1. Set ke `/path/to/bukaolshop-admin/public`
2. Restart Apache

**Jika tidak bisa (shared hosting):**
1. Rename `/public` ke nama folder domain Anda
2. Atau contact hosting support untuk set document root

## Step 5: Testing

### Cek Setup

Open browser dan akses:
```
http://yourdomain.com/
```

Atau (jika tidak support .htaccess):
```
http://yourdomain.com/public/
http://yourdomain.com/public/index.php?page=login
```

### Login

**Demo Account:**
- Username: `admin`
- Password: `admin123`

## Step 6: Input API Key BukaOlshop

1. Login ke admin panel
2. Go to Pengaturan > API Key BukaOlshop
3. Copy API Key dari aplikasi BukaOlshop
4. Paste dan Save

**Cara dapat API Key:**
1. Buka aplikasi BukaOlshop (Android)
2. Menu > Pengaturan
3. Cari "API Key" atau "Generate API Key"
4. Copy API Key yang muncul

## Troubleshooting

### Error 500 - Internal Server Error

**Solution:**
1. Check file `/logs/error.log`
2. Pastikan folder permissions 755
3. Check PHP version >= 7.4
4. Check MySQL connection

### Error 404 - Page Not Found

**Solution:**
1. Check .htaccess di `/public/`
2. Enable mod_rewrite
3. Pastikan document root pointing ke `/public`

### Error: Cannot connect to database

**Solution:**
```php
// Edit /config/config.php
define('DB_HOST', '127.0.0.1');  // Ganti localhost ke 127.0.0.1
// Atau
define('DB_PORT', 3307);         // Ganti port jika berbeda
```

### Error: Headers already sent

**Solution:**
1. Check file `/config/config.php` line 1 - harus `<?php` tanpa space sebelumnya
2. Check file encoding - harus UTF-8 without BOM
3. Pastikan tidak ada newline setelah `?>`

### Upload CSV tidak berjalan

**Solution:**
1. Check folder `/uploads` permissions (755)
2. Check PHP `upload_max_filesize` >= 10MB
3. Check file format CSV (use Excel, save as CSV UTF-8)

### API Error 401 Unauthorized

**Solution:**
1. API Key salah atau kadaluarsa
2. Generate API Key baru di aplikasi BukaOlshop
3. Update di Pengaturan admin panel

## Keamanan

### Change Default Password

```sql
UPDATE admin_users 
SET password = PASSWORD('NewPassword123') 
WHERE username = 'admin'
LIMIT 1;
```

### Create New Admin User

```sql
INSERT INTO admin_users 
(username, email, password, api_key, is_active) 
VALUES 
('adminbaru', 'admin@email.com', PASSWORD('password123'), 'api_key_here', 1);
```

### Enable HTTPS

Edit `/public/.htaccess`:
```apache
# Uncomment RewriteCond dan RewriteRule untuk HTTPS
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

### Regular Backup

```bash
# Database backup
mysqldump -u root -p bukaolshop_admin > backup_$(date +%Y%m%d).sql

# File backup
tar -czf backup_$(date +%Y%m%d).tar.gz /path/to/bukaolshop-admin/
```

## Performance Tips

1. **Clear Cache Regularly**
   - Go to Dashboard
   - Click "Clear Cache"
   - Atau manual via admin panel

2. **Database Optimization**
   ```sql
   OPTIMIZE TABLE products;
   OPTIMIZE TABLE upload_queue;
   OPTIMIZE TABLE kategori;
   ```

3. **Enable Gzip Compression**
   Edit `/public/.htaccess`:
   ```apache
   <IfModule mod_deflate.c>
     AddOutputFilterByType DEFLATE text/html
     AddOutputFilterByType DEFLATE text/css
     AddOutputFilterByType DEFLATE application/javascript
   </IfModule>
   ```

## Support & Help

1. **Check Logs:** `/logs/error.log`
2. **Database Error:** Check error pada MySQL
3. **API Error:** Check BukaOlshop API documentation
4. **Server Issue:** Contact hosting provider

## Quick Reference

| Item | Command |
|------|---------|
| Fix permissions | `chmod -R 755 /` |
| View error log | `tail -f logs/error.log` |
| Clear temp | `rm uploads/temp_*` |
| Database backup | `mysqldump -u root -p bukaolshop_admin > backup.sql` |
| Database restore | `mysql -u root -p bukaolshop_admin < backup.sql` |

---

**Installation Complete!** 🎉

System siap digunakan. Mulai upload produk Anda sekarang!
